{
Copyright  1999 by Delphi 5 Developer's Guide - Xavier Pacheco and Steve Teixeira
}

unit MainFrm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, FileCtrl;

type

  TMainForm = class(TForm)
    btnSearch: TButton;
    lbFilesFound: TListBox;
    edtSearchString: TEdit;
    lblSearchString: TLabel;
    lblFilesFound: TLabel;
    memFileText: TMemo;
    btnFindNext: TButton;
    FindDialog: TFindDialog;
    SpeedButton1: TSpeedButton;
    procedure btnSearchClick(Sender: TObject);
    procedure lbFilesFoundClick(Sender: TObject);
    procedure btnFindNextClick(Sender: TObject);
    procedure FindDialogFind(Sender: TObject);
    procedure edtSearchStringChange(Sender: TObject);
    procedure memFileTextChange(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  public
  end;

var
  MainForm: TMainForm;

implementation
uses MemMap, Search, Unit1;

{$R *.DFM}

procedure TMainForm.btnSearchClick(Sender: TObject);
var
  MemMapFile: TMemMapFile;
  SearchRec: TSearchRec;
  RetVal: Integer;
  FoundStr: PChar;
  FName: String;
  FindString: String;
  WordCount: Integer;
begin
  //btnSearch.Enabled:=false;
  //btnFindNext.Enabled := False;
  { Retrieve each text file on which the text search is to be
    performed. Use the FindFirst/FindeNext sequence on this search. }
  RetVal := FindFirst(Form1.OpenDialog1.InitialDir+'\*.cci', faAnyFile, SearchRec);
  try
    while RetVal = 0 do
    begin
      FName := SearchRec.Name;

      // Open the memory mapped file for read-only access.
      MemMapFile := TMemMapFile.Create(FName, fmOpenRead, 0, True);
      try

        { Use a temporary storage for the search string }
        FindString := edtSearchString.Text;

        WordCount := 0; // Initialize the WordCount to zero
        { Get the first occurrence of the search string  }
        FoundStr := StrPos(PChar(MemMapFile.Data), PChar(FindString));

        if FoundStr <> nil then
        begin
          { Continue to search through the remaining text of the file
            for occurrences of the search string. On each find,
            increment the WordCount variable }
          repeat
            inc(WordCount);
            inc(FoundStr, Length(FoundStr));

            { Retrieve the next occurrence of the search string. }
            FoundStr := StrPos(PChar(FoundStr), PChar(FindString));
          until FoundStr = nil;
          { Add the file's name to the list box }
          lbFilesFound.Items.Add(SearchRec.Name +
             ' - '+IntToStr(WordCount));
        end;
        { Retrieve the next file on which to perform the search }
        RetVal := FindNext(SearchRec);
      finally
        MemMapFile.Free; { Free the memory mapped file instance }
      end;
    end;
  finally
    FindClose(SearchRec);
  end;
end;

procedure TMainForm.lbFilesFoundClick(Sender: TObject);
var
  FName: String;
  B: Byte;
begin
  with lbFilesFound do
    if ItemIndex <> -1 then
    begin
      B := Pos(' ', Items[ItemIndex]);
      FName := Copy(Items[ItemIndex], 1, B);
      memFileText.Clear;
      memFileText.Lines.LoadFromFile(FName);
    end;
end;

procedure TMainForm.btnFindNextClick(Sender: TObject);
begin
  FindDialog.FindText := edtSearchString.Text;
  //FindDialog.Execute;
  FindDialog.Top := Top+Height;
  FindDialogFind(FindDialog);
end;

procedure TMainForm.FindDialogFind(Sender: TObject);
begin
  with Sender as TFindDialog do
    if not SearchMemo(memFileText, FindText, Options) then
      ShowMessage('No foi achado "' + FindText + '".');
end;

procedure TMainForm.edtSearchStringChange(Sender: TObject);
begin
  btnSearch.Enabled := edtSearchString.Text <> EmptyStr;
end;

procedure TMainForm.memFileTextChange(Sender: TObject);
begin
  btnFindNext.Enabled := memFileText.Lines.Count > 0;
end;

procedure TMainForm.SpeedButton1Click(Sender: TObject);
begin
close;
end;

procedure TMainForm.FormCreate(Sender: TObject);
var WordCount:integer;
begin
WordCount:=0;
end;

end.
